﻿using System;
using System.Windows.Forms;
using RDR2;
using RDR2.UI;
using RDR2.Native;
using RDR2.Math;

namespace HCL_Superpower_02
{
    public class Main : Script
    {
/// /////////////////////////////////////////////
        float LightRange = 80.0f;  //  This is the range of the light.
        float LightIntensity = 5.0f;  //  This is the intensity of the light.
        Keys LightKey = Keys.X;  // The key that switches the illumination, can set to any key beside Shift, Alt or Control.
/// /////////////////////////////////////////////
        Player player = Game.Player;
        Ped playerPed = Game.Player.Character;
        bool LightOn = false;

        public Main()
        {
            KeyDown += OnKeyDown;
            KeyUp += OnKeyUp;
            Tick += OnTick;
            Interval = 1;
        }

        private void OnTick(object sender, EventArgs e)
        {  
            if (LightOn)
            {
                     if (player.IsDead)
                     {
                            LightOn = false;
                     }
                     else
                     {
                            Function.Call(Hash.DRAW_RECT, 0.05, 0.5, 0.0075, 0.015, 225, 225, 225, 255); 
                            Function.Call(Hash.DRAW_RECT, 0.05, 0.5, 0.005, 0.01, 55, 55, 55, 255); 
                            Function.Call(Hash.DRAW_LIGHT_WITH_RANGE, (playerPed.Position.X), (playerPed.Position.Y), (playerPed.Position.Z + 1.0f), 255, 255, 255, LightRange, LightIntensity);
                     }
            }
        } 

        private void OnKeyDown(object sender, KeyEventArgs e)
        {

        }

        private void OnKeyUp(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == LightKey && !e.Shift)
            {
                     if (LightOn)
                     {
                           LightOn = false;
	           RDR2.UI.Screen.ShowSubtitle("Illumination Off");
                     }
                     else
                     {
                           LightOn = true;
	           RDR2.UI.Screen.ShowSubtitle("Illumination On");
                     }
            }
        }
    }
}
